function [ F21 ] = m2F1( n1,n2,nu,zh )
%Hypergeometric function
% within unif circle for z:
%   absolute conv if Re(c-a-b)>0
%   divergent     if Re(c-a-b)<= -1
%   conditional conv if -1 < Re(c-a-b) <= 0
%   take 25 iterations
a=(n1+n2-nu)/2;
b=(-n1+n2-nu)/2;
c=n2+1;
z=zh*zh;
fs=0;
for i=1:25
    fs = fs + gamma(a+i)*gamma(b+i)*z^i /(gamma(c+i)*gamma(i+1));
end
fs= 1 + fs*gamma(c)/(gamma(a)*gamma(b));
F21= fs;

end

